<!-- pricing modal  -->
<div class="modal fade" id="pricingModal" tabindex="-1" aria-labelledby="pricingModalTitle" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-xl">
    <div class="modal-content">
      <div class="modal-header bg-transparent">
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body px-sm-5 mx-50 pb-5">
        <div id="pricing-plan">
          <!-- title text and switch button -->
          <div class="text-center">
            <h1 id="pricingModalTitle">Subscription Plan</h1>
            <p class="mb-3">
              All plans include 40+ advanced tools and features to boost your product. Choose the best plan to fit your
              needs.
            </p>
            <div class="d-flex align-items-center justify-content-center mb-2 pb-50">
              <h6 class="me-1 mb-0">Monthly</h6>
              <div class="form-check form-switch">
                <input type="checkbox" class="form-check-input" id="priceSwitch" />
                <label class="form-check-label" for="priceSwitch"></label>
              </div>
              <h6 class="ms-50 mb-0">Annually</h6>
            </div>
          </div>
          <!--/ title text and switch button -->

          <!-- pricing plan cards -->
          <div class="row pricing-card">
            <!-- basic plan -->
            <div class="col-12 col-lg-4">
              <div class="card basic-pricing border text-center shadow-none">
                <div class="card-body">
                  <img src="{{asset('images/illustration/Pot1.svg')}}" class="mb-2 mt-5" alt="svg img" />
                  <h3>Basic</h3>
                  <p class="card-text">A simple start for everyone</p>
                  <div class="annual-plan my-2">
                    <div class="d-flex justify-content-center plan-price">
                      <sup class="d-block font-medium-1 fw-bold text-primary mt-2">$</sup>
                      <span class="pricing-basic-value fw-bolder text-primary font-large-3 lh-1">0</span>
                      <sub class="pricing-duration text-body font-medium-1 fw-bold mt-3">/month</sub>
                    </div>
                  </div>
                  <ul class="list-group list-group-circle text-start fw-bold">
                    <li class="list-group-item">100 responses a month</li>
                    <li class="list-group-item">Unlimited forms and surveys</li>
                    <li class="list-group-item">Unlimited fields</li>
                    <li class="list-group-item">Basic form creation tools</li>
                    <li class="list-group-item">Up to 2 subdomains</li>
                  </ul>
                  <button class="btn w-100 btn-outline-success mt-2">Your current plan</button>
                </div>
              </div>
            </div>
            <!--/ basic plan -->

            <!-- standard plan -->
            <div class="col-12 col-lg-4">
              <div class="card standard-pricing border-primary text-center shadow-none">
                <div class="card-body">
                  <div class="pricing-badge text-end">
                    <span class="badge rounded-pill badge-light-primary">Popular</span>
                  </div>
                  <img src="{{asset('images/illustration/Pot2.svg')}}" class="mb-1" alt="svg img" />
                  <h3>Standard</h3>
                  <p class="card-text">For small to medium businesses</p>
                  <div class="annual-plan my-2">
                    <div class="d-flex justify-content-center plan-price">
                      <sup class="d-block font-medium-1 fw-bold text-primary mt-2">$</sup>
                      <span class="pricing-standard-value fw-bolder text-primary font-large-3 lh-1">49</span>
                      <sub class="pricing-duration text-body font-medium-1 fw-bold mt-3">/month</sub>
                    </div>
                    <small class="annual-pricing d-none text-muted"></small>
                  </div>
                  <ul class="list-group list-group-circle text-start fw-bold">
                    <li class="list-group-item">Unlimited responses</li>
                    <li class="list-group-item">Unlimited forms and surveys</li>
                    <li class="list-group-item">Instagram profile page</li>
                    <li class="list-group-item">Google Docs integration</li>
                    <li class="list-group-item">Custom “Thank you” page</li>
                  </ul>
                  <button class="btn w-100 btn-primary mt-2">Upgrade</button>
                </div>
              </div>
            </div>
            <!--/ standard plan -->

            <!-- enterprise plan -->
            <div class="col-12 col-lg-4">
              <div class="card enterprise-pricing border text-center shadow-none">
                <div class="card-body">
                  <img src="{{asset('images/illustration/Pot3.svg')}}" class="mb-2" alt="svg img" />
                  <h3>Enterprise</h3>
                  <p class="card-text">Solution for big organizations</p>
                  <div class="annual-plan my-2">
                    <div class="d-flex justify-content-center plan-price">
                      <sup class="d-block font-medium-1 fw-bold text-primary mt-2">$</sup>
                      <span class="pricing-enterprise-value fw-bolder text-primary font-large-3 lh-1">99</span>
                      <sub class="pricing-duration text-body font-medium-1 fw-bold mt-3">/month</sub>
                    </div>
                    <small class="annual-pricing d-none text-muted"></small>
                  </div>
                  <ul class="list-group list-group-circle text-start fw-bold">
                    <li class="list-group-item">PayPal payments</li>
                    <li class="list-group-item">Logic Jumps</li>
                    <li class="list-group-item">File upload with 5GB storage</li>
                    <li class="list-group-item">Custom domain support</li>
                    <li class="list-group-item">Stripe integration</li>
                  </ul>
                  <button class="btn w-100 btn-outline-primary mt-2">Upgrade</button>
                </div>
              </div>
            </div>
            <!--/ enterprise plan -->
          </div>
          <!--/ pricing plan cards -->

          <!-- pricing free trial -->
          <div class="text-center">
            <p>Still not convinced? Start with a 14-day FREE trial!</p>
            <button class="btn btn-primary">Start your trial</button>
          </div>
          <!--/ pricing free trial -->
        </div>
      </div>
    </div>
  </div>
</div>
<!-- / pricing modal  -->
