from django.urls import path
from .views import UIView
from django.contrib.auth.decorators import login_required


urlpatterns = [
    path(
        "ui/accordion/",
        login_required(UIView.as_view(template_name="ui_accordion.html")),
        name="ui-accordion",
    ),
    path(
        "ui/alerts/",
        login_required(UIView.as_view(template_name="ui_alerts.html")),
        name="ui-alerts",
    ),
    path(
        "ui/badges/",
        login_required(UIView.as_view(template_name="ui_badges.html")),
        name="ui-badges",
    ),
    path(
        "ui/buttons/",
        login_required(UIView.as_view(template_name="ui_buttons.html")),
        name="ui-buttons",
    ),
    path(
        "ui/carousel/",
        login_required(UIView.as_view(template_name="ui_carousel.html")),
        name="ui-carousel",
    ),
    path(
        "ui/collapse/",
        login_required(UIView.as_view(template_name="ui_collapse.html")),
        name="ui-collapse",
    ),
    path(
        "ui/dropdowns/",
        login_required(UIView.as_view(template_name="ui_dropdowns.html")),
        name="ui-dropdowns",
    ),
    path(
        "ui/footer/",
        login_required(UIView.as_view(template_name="ui_footer.html")),
        name="ui-footer",
    ),
    path(
        "ui/list_groups/",
        login_required(UIView.as_view(template_name="ui_list_groups.html")),
        name="ui-list-groups",
    ),
    path(
        "ui/modals/",
        login_required(UIView.as_view(template_name="ui_modals.html")),
        name="ui-modals",
    ),
    path(
        "ui/navbar/",
        login_required(UIView.as_view(template_name="ui_navbar.html")),
        name="ui-navbar",
    ),
    path(
        "ui/offcanvas/",
        login_required(UIView.as_view(template_name="ui_offcanvas.html")),
        name="ui-offcanvas",
    ),
    path(
        "ui/pagination_breadcrumbs/",
        login_required(UIView.as_view(template_name="ui_pagination_breadcrumbs.html")),
        name="ui-pagination-breadcrumbs",
    ),
    path(
        "ui/progress/",
        login_required(UIView.as_view(template_name="ui_progress.html")),
        name="ui-progress",
    ),
    path(
        "ui/spinners/",
        login_required(UIView.as_view(template_name="ui_spinners.html")),
        name="ui-spinners",
    ),
    path(
        "ui/tabs_pills/",
        login_required(UIView.as_view(template_name="ui_tabs_pills.html")),
        name="ui-tabs-pills",
    ),
    path(
        "ui/toasts/",
        login_required(UIView.as_view(template_name="ui_toasts.html")),
        name="ui-toasts",
    ),
    path(
        "ui/tooltips_popovers/",
        login_required(UIView.as_view(template_name="ui_tooltips_popovers.html")),
        name="ui-tooltips-popovers",
    ),
    path(
        "ui/typography/",
        login_required(UIView.as_view(template_name="ui_typography.html")),
        name="ui-typography",
    ),
]
